#include maps\mp\_utility;
#include maps\mp\gametypes\_hud_util;
#include common_scripts\utility;

createInfoHud(){
	self.HintText = self createFontString( "objective", 1.25 );
	self.HintText setPoint( "CENTER", "CENTER", 0, 50 );
	self.HintText.archived = false;
	self.HintText thread destroyOnNotify(self, 1);

	self.InfoHud = [];
	self.InfoHud[0] = self createFontString("objective", 1.1);
	self.InfoHud[0].archived = false;
	self.InfoHud[0] setPoint("TOPLEFT", "TOPLEFT", 10, 122);
	self.InfoHud[0].HideWhenInMenu = true;
	self.InfoHud[0].color = ( 1.0, 1.0, 1.0 );
	self.InfoHud[0].glow = 1;
	self.InfoHud[0].glowColor = ( (93/255), (255/255), (75/255) );
	self.InfoHud[0].glowAlpha = 0.4;
	self.InfoHud[0].alpha = 1;
	self.InfoHud[0].label = &"Health: ";
	self.InfoHud[0].sort = 50;
	self.InfoHud[0] thread destroyOnNotify(self, 1);
	self.InfoHud[0].sort = 10000;

	self.InfoHud[1] = self createFontString("objective", 1.1);
	self.InfoHud[1].archived = false;
	self.InfoHud[1] setPoint("TOPLEFT", "TOPLEFT", 10, 134);
	self.InfoHud[1].HideWhenInMenu = true;
	self.InfoHud[1].color = ( 1.0, 1.0, 1.0 );
	self.InfoHud[1].glowAlpha = 0.4;
	self.InfoHud[1].alpha = 1;
	self.InfoHud[1].glow = 1;
	self.InfoHud[1].glowColor = ( (255/255), (98/255), (98/255) );
	self.InfoHud[1].label = &"Cash: $";
	self.InfoHud[1].sort = 50;
	self.InfoHud[1] thread destroyOnNotify(self, 1);
	self.InfoHud[1].sort = 10000;
	
	self.InfoHud[2] = self createFontString("objective", 1.1);
	self.InfoHud[2].archived = false;
	self.InfoHud[2] setPoint("TOPLEFT", "TOPLEFT", 10, 146);
	self.InfoHud[2].HideWhenInMenu = true;
	self.InfoHud[2].color = ( 1.0, 1.0, 1.0 );
	self.InfoHud[2].glowAlpha = 0.4;
	self.InfoHud[2].alpha = 1;
	self.InfoHud[2].glow = 1;
	self.InfoHud[2].glowColor = ( (0/255), (111/255), (255/255) );
	self.InfoHud[2].sort = 50;
	self.InfoHud[2] thread destroyOnNotify(self, 1);
	self.InfoHud[2].sort = 10000;


	self.ZombieCounter = createPrimaryProgressBar( 150 );
	self.ZombieCounter setPoint("BOTTOMLEFT", "BOTTOMLEFT", 10, -78);
	self.ZombieCounter.bar.color=((255/255),(102/255),(102/255));
	self.ZombieCounter.bar.x += 2;
	self.ZombieCounter.bar.y -= 2;
	self.ZombieCounter.bar.HideWhenInMenu = true;
	self.ZombieCounter.HideWhenInMenu = true;
	self.ZombieCounter thread destroyOnNotify(self, 2);
	self.ZombieCounterText = createPrimaryProgressBarText( 147 );
	self.ZombieCounterText.color=((255/255),(102/255),(102/255));
	self.ZombieCounterText setPoint("BOTTOMLEFT", "BOTTOMLEFT", 10, -88);
	self.ZombieCounterText.label = &"Zombies Left: ";
	self.ZombieCounterText.HideWhenInMenu = true;
	self.ZombieCounterText.fontscale = 0.5;
	self.ZombieCounterText thread destroyOnNotify(self, 1);

	self.RoundCounterText = self createFontString("default", 0.7);
	self.RoundCounterText.color=((255/255),(102/255),(102/255));
	self.RoundCounterText setPoint("BOTTOMLEFT", "BOTTOMLEFT", 10, -98);
	self.RoundCounterText.label = &"^1Round: ";
	self.RoundCounterText.HideWhenInMenu = true;
	self.RoundCounterText thread destroyOnNotify(self, 1);
	

	if(!isDefined(self.Store[0]))
	{
		for(i=1;i<4;i++)
		{
			self.Store[i] = self createFontString("objective", 1.1);
			self.Store[i].archived = false;
			self.Store[i] setPoint("TOPLEFT", "TOPLEFT", 10, 158);
			self.Store[i].HideWhenInMenu = false;
			self.Store[i].color = ( 1.0, 1.0, 1.0 );
			self.Store[i].alpha = 0;
			self.Store[i].glow = 1;
			self.Store[i].glowColor = ( (82/255), (128/255), (94/255) );
			self.Store[i].glowAlpha = 1;
			self.Store[i].sort = 10000;
			self.Store[i] thread destroyOnNotify(self, 1);
		}
	}
	
	//self.Store[0].y = 122;
	self.Store[1].y = 162;
	self.Store[2].y = 174;
	self.Store[3].y = 186;
	
	if(!self.StoreIdle)
	{
		self.Store[1].alpha = 1;
		self.Store[2].alpha = 1;
		self.Store[3].alpha = 1;
	}
	self thread updateZombieCount();
	self thread updateMoney();
	self thread updateRound();
	self thread updatehealth();
	self thread updateMenuBindings();
}

updateMenuBindings(){
	self endon("disconnect");

	self.menuButton = [];

	for(;;){
		if(common_scripts\utility::is_player_gamepad_enabled()){
			self.InfoHud[2] setSafeText ("[{+actionslot 1}] - Store");
			self.menuButton[1] = "[{+actionslot 3}] ";
			self.menuButton[2] = "[{+actionslot 4}] ";
			self.menuButton[3] = "[{+actionslot 2}] ";
		}
		else{
			self.InfoHud[2] setSafeText ("[{+mlook}] - Store");
			self.menuButton[1] = "[{+leanleft}]";
			self.menuButton[2] = "[{+leanright}]";
			self.menuButton[3] = "[{+actionslot 3}]";
		}
		wait 1;
	}
}

ShowMenu()
{
	self endon("dealth");
	self endon("disconnect");
	
	self.MenuIdleTime = 7;
	
	if( self.StoreIdle == 0 )
		return;
	
	self.StoreIdle = 0;
	
	for(i=1;i<=3;i++)
	{
		self.Store[i].alpha = 1;
	}
	
	while(self.MenuIdleTime >= 0)
	{
		wait 1;
		self.MenuIdleTime -= 1;
	}

	self thread HideStore(0.3);
}

HideStore(time)
{
	self endon("dealth");
	self endon("disconnect");

	if(!isDefined(time))
		time = 0;
	
	self.StoreIdle = 1;
	
	for(i=1;i<=3;i++)
	{
		self.Store[i] fadeOverTime(time);
		self.Store[i].alpha = 0;
	}
}

DestroyAllClientText()
{
	for(i=0;i<5;i++)
	{
		if(isDefined(self.store[i]))
		{
			self.store[i] Destroy();
		}
	}
	if(isDefined(self.HealthHud))
	{
		self.HealthHud Destroy();
	}
	if(isDefined(self.HintText))
	{
		self.HintText Destroy();
	}
	if(isDefined(self.whd))
		self.whd Destroy();
	if(isDefined(self.shd))
		self.shd Destroy();
	if(isDefined(self.cbc))
		self.cbc Destroy();
}

updateZombieCount(){
	self endon("disconnect");
	while(1)
	{
		if(level.zKills<=level.roundKills){
			self.ZombieCounter updateBar(level.zKills/level.roundKills);
		}
		else if(level.zKills>level.roundKills){
			self.ZombieCounter updateBar(level.roundKills/level.roundKills);
		}
		if((level.roundKills-level.zKills) >= 0){
			self.ZombieCounterText setValue(level.roundKills-level.zKills);
		}
		else if((level.roundKills-level.zKills) < 0){
			self.ZombieCounterText setValue(0);
		}
		wait 0.5;
	}
}

updateRound(){
	zround = undefined;
	self endon("disconnect");
	while(1)
	{
		if(self.Zround != level.roundz){
			self.RoundCounterText setvalue(level.roundz);
			self.Zround = level.roundz;
		}
		wait 0.025;
	}
}

updateMoney(){
	oldCash = undefined;
	self endon("disconnect");
	while(1)
	{
		if(self.money != oldCash){
			self.InfoHud[1] setvalue(self.money);
			oldCash = self.money;
		}
		wait 0.025;
	}
}

updatehealth()
{
	self endon("disconnect");
	oldHealth = 0;
	while(1)
	{
		if(self.health != oldHealth){
			self.InfoHud[0] setvalue(self.health);
			oldHealth = self.health;
		}
		wait 0.025;
	}
}



unlockText(text){
	if(!isDefined(self.unlockText))
	{
		self.unlockText = self createFontString( "objective", 1 );
		self.unlockText setPoint( "TOPCENTER", "TOPCENTER", 0, 10 );
		self.unlockText.HideWhenInMenu = true;
		self.unlockText.archived = false;
		self.unlockText thread destroyOnNotify(self, 1);
	}
	//self playLocalSound("NS_mp_rsp_greatshot");
	self notify("spam_protection_unlocks");
	self endon("spam_protection_unlocks");
	self.unlockText fadeovertime(0.05);
	self.unlockText.alpha = 1;
	self.unlockText ChangeFontScaleOverTime( 0.2 );
	self.unlockText.fontScale = 1.5;
	self.unlockText setText(text);
	wait 0.2;
	self.unlockText ChangeFontScaleOverTime( 0.1 );
	self.unlockText.fontScale = 1.25;
	wait 1.5;
	self.unlockText fadeovertime(1.5);
	self.unlockText.alpha = 0;
}


iPrintlnText(text){
	if(!isDefined(self.iPrintlnText))
	{
		self.iPrintlnText = self createFontString( "default", 1.25 );
		self.iPrintlnText setPoint( "CENTER", "CENTER", 0, -120 );
		self.iPrintlnText.archived = false;
		self.iPrintlnText thread destroyOnNotify(self, 1);
	}
	self.iPrintlnText thread doPrintFx(text);
}

doPrintFx(text){
	self notify("spam_protection");
	self endon("spam_protection");
	self fadeovertime(0.05);
	self.alpha = 1;
	self ChangeFontScaleOverTime( 0.1 );
	self.fontScale = 1.5;
	self setText(text);
	wait 0.1;
	self ChangeFontScaleOverTime( 0.1 );
	self.fontScale = 1.25;
	wait 1;
	self fadeovertime(1);
	self.alpha = 0;
}

ZombieSkillBar(){
	if(!isDefined(self.skillBar)){
		self.skillBar = createPrimaryProgressBar( 150 );
		self.skillBar setPoint("BOTTOMRIGHT", "BOTTOMRIGHT", -10, -78);
		self.skillBar.bar.x -= 2;
		self.skillBar.bar.y -= 2;
		self.skillBar.bar.HideWhenInMenu = true;
		self.skillBar.HideWhenInMenu = true;
		self.skillBar thread destroyOnNotifySkill(self, 2);
	}
	if(!isDefined(self.skillText)){
		self.skillText = createPrimaryProgressBarText( 147 );
		self.skillText.color=((255/255),(102/255),(102/255));
		self.skillText setPoint("BOTTOMRIGHT", "BOTTOMRIGHT", -10, -103);
		self.skillText.HideWhenInMenu = true;
		self.skillText thread destroyOnNotifySkill(self, 1);
	}
}

destroyOnNotifySkill(owner, type)
{
	owner waittill_any("death", "disconnect", "zombieSkillOver");
	if(type == 1)
		self destroy();
	else if(type == 2)
		self DestroyElem();
}

CreatescorePopup()
{
	self.hud_scorePopup = self createFontString("hudbig", 1);
	self.hud_scorePopup setPoint("BOTTOMCENTER", "BOTTOMCENTER", 0, -170);
	self.hud_scorePopup.archived = false;
	self.hud_scorePopup.color = (0.5,0.5,0.5);
	self.hud_scorePopup.sort = 10000;
	self.hud_scorePopup maps\mp\gametypes\_hud::fontPulseInit( 0.8 );
	self.hud_scorePopup.line = self createIcon( "line_horizontal", 150, 2 );
	self.hud_scorePopup.line setPoint("BOTTOMCENTER", "BOTTOMCENTER", 0, -170);
	self.hud_scorePopup.line.alpha = 0;
	self.hud_scorePopup thread destroyOnNotify(self, 1);
	self.xpUpdatedTotal = 0;
	self.bonusUpdateTotal = 0;
}

scorePopup( amount, bonus, hudColor, glowAlpha )
{
	self endon( "disconnect" );

	if ( amount == 0 )
		return;

	self notify( "scorePopup" );
	self endon( "scorePopup" );

	self.xpUpdatedTotal += amount;
	self.bonusUpdateTotal += bonus;

	wait ( 0.05 );

	if ( self.xpUpdatedTotal < 0 )
	{
		self.hud_scorePopup.label = &"$";
		self.hud_scorePopup.color = hudColor;
		self.hud_scorePopup.line.color = (0.9, 0.3, 0.3);
		self.hud_scorePopup.glowColor = (0.9, 0.3, 0.3);
		self.hud_scorePopup.glowAlpha = 0.55;
	}
	else
	{
		self.hud_scorePopup.label = &"+$";
		self.hud_scorePopup.color = hudColor;
		self.hud_scorePopup.line.color = (0.3, 0.9, 0.3);
		self.hud_scorePopup.glowColor = (0.3, 0.9, 0.3);
		self.hud_scorePopup.glowAlpha = 0.55;
	}

	self.hud_scorePopup setValue(self.xpUpdatedTotal);
	self.hud_scorePopup.alpha = 0.85;
	self.hud_scorePopup.line.alpha = 1;
	self.hud_scorePopup.line fadeOverTime(0.5);
	self.hud_scorePopup SetPulseFX( 80, 120000, 600 );
	wait 2; // Give time to process pulse FX
	
	incrementCash = max( int( self.xpUpdatedTotal / 20 ), 1 );
	incrementCashMinus = max( int( self.xpUpdatedTotal / -20 ), -1 );
	increment = max( int( self.bonusUpdateTotal / 20 ), 1 );
	wait 1;
	while ( self.xpUpdatedTotal > 1 )
	{
		minusMoney = min( self.xpUpdatedTotal, incrementCash );
		self.xpUpdatedTotal -= minusMoney;

		self.hud_scorePopup setValue( self.xpUpdatedTotal );		

		wait ( 0.05 );
	}
	while ( self.xpUpdatedTotal < -1 )
	{
		minusMoney = min( self.xpUpdatedTotal, incrementCashMinus );
		self.xpUpdatedTotal -= minusMoney;
		
		self.hud_scorePopup setValue( self.xpUpdatedTotal );		

		wait ( 0.05 );
	}
	self.hud_scorePopup fadeOverTime( 0.75 );
	self.hud_scorePopup.alpha = 0;
	self.hud_scorePopup.line fadeOverTime( 0.75 );
	self.hud_scorePopup.line.alpha = 0;
	
	self.xpUpdatedTotal = 0;		
}

zombieOverlay(){
	zombieOverlay = newClientHudElem( self );
	zombieOverlay.horzAlign = "fullscreen";
	zombieOverlay.vertAlign = "fullscreen";
	zombieOverlay setShader( "combathigh_overlay", 640, 480 );
	zombieOverlay.color=((255/255),(0/255),(0/255));
	zombieOverlay.archive = true;
	zombieOverlay.sort = 0;
	zombieOverlay thread destroyOnNotify(self, 1);
}

destroyOnNotify(owner, type)
{
	owner waittill_any("game_ended");
	if(type == 1)
		self destroy();
	else if(type == 2)
		self DestroyElem();
}

createGameText(){
	level.GameText = level createServerFontString("objective",1.5);
	level.GameText setPoint("CENTER","CENTER",0,-120);
	level.GameText thread destroyOnNotify(self, 1);
}

showGameText(text, i){
	level notify("showGameText");
	level endon("showGameText");
	level.GameText setSafeText(text);
	wait i;
	level.GameText setSafeText("");
}

setSafeText(text)
{
	if(self.oldText != text)
	{
		//iPrintLn(text);
		self.oldText = text;
		level.textresult += 1;
		level notify("textset");
		self setText(text);
	}
}

setSafeMSGText(text)
{
	if(!self.MSG && text != "")
	{
		self.HintText setSafeText(text);
		self.MSG = 1;
	}
	else if(self.MSG && text == "")
	{
		self.HintText setSafeText(text);
		self.MSG = 0;
	}
}

JoinMessage()
{
	self waittill("spawned_player");
	if(!self.FirstSpawn)
	{
		self.FirstSpawn=1;
		wait 5;
		notifyHello=spawnstruct();
		notifyHello.titleText="Hawkin's Zombieland v4.0";
		notifyHello.notifyText="Edited By LightModz and TheUncleBobbyB";
		notifyHello.glowColor =(0.0,0.6,0.3);
		notifyHello.duration = 6.0;
		self thread maps\mp\gametypes\_hud_message::notifyMessage(notifyHello);
	}
}